<?php
get_header();
get_template_part('template-parts/header/single-member', 'header');
$postID = get_the_ID();
while(have_posts()): the_post();

    $mem_designation = '';
    $mem_experience = '';
    $mem_qualifications = '';
    $mem_socials = array();
    $mem_facts = array();
    if(defined('FW')):
        $mem_designation = fw_get_db_post_option(get_the_ID(), 'mem_designation', '');
        $mem_experience = fw_get_db_post_option(get_the_ID(), 'mem_experience', '');
        $mem_qualifications = fw_get_db_post_option(get_the_ID(), 'mem_qualifications', '');
        $mem_socials = fw_get_db_post_option(get_the_ID(), 'mem_socials', array());
        $mem_facts = fw_get_db_post_option(get_the_ID(), 'mem_facts', array());
    endif;
?>
<section class="commonSection singleMemberSection">
    <div class="container">
        <div class="row">
            <div class="col-md-6">
                <div class="td_thumbs">
                    <?php
                        if(has_post_thumbnail()):
                            echo get_the_post_thumbnail(get_the_ID(), 'industing-team-3');
                        else:
                            echo '<img src="http://via.placeholder.com/570x570" alt="'.  the_title_attribute( 'echo=0' ).'">';
                        endif;
                    ?>
                </div>
            </div>
            <div class="col-md-6">
                <div class="member_details_area">
                    <h3><?php echo get_the_title(); ?></h3>
                    <?php if($mem_designation != ''): ?>
                        <span><?php echo esc_html($mem_designation); ?></span>
                    <?php endif; ?>
                    <div class="mem_det">
                        <?php the_content(); ?>
                    </div>
                    <?php if($mem_experience != '' || $mem_qualifications != ''): ?>
                    <ul class="member_meta">
                        <?php if($mem_experience != ''): ?>
                        <li><i class="twi-thumbs-up2"></i><span><?php echo esc_html__('Experience:', 'industing') ?></span><?php echo esc_html($mem_experience); ?></li>
                        <?php endif; ?>
                        <?php if($mem_qualifications != ''): ?>
                        <li><i class="twi-lightbulb-on2"></i><span><?php echo esc_html__('Qualification:', 'industing') ?></span><?php echo esc_html($mem_qualifications); ?></li>
                        <?php endif; ?>
                    </ul>
                    <?php endif; ?>
                    <?php if(is_array($mem_socials) && !empty($mem_socials)): ?>
                        <div class="memSocial">
                            <?php
                                foreach($mem_socials as $ms):
                                    $mem_social_icon = (isset($ms['mem_social_icon']) && $ms['mem_social_icon'] != '') ? $ms['mem_social_icon'] : '';
                                    if(isset($mem_social_icon['type']) && $mem_social_icon['type'] == 'icon-font'){
                                        if(isset($mem_social_icon['icon-class']) && $mem_social_icon['icon-class'] != ''){
                                            $icon = $mem_social_icon['icon-class'];
                                        };
                                    }else{
                                            $icon = 'twi-facebook-f';
                                    }
                                    $mem_social_url  = (isset($ms['mem_social_url']) && $ms['mem_social_url'] != '') ? $ms['mem_social_url'] : '#';
                                    if($icon != ''):
                                        echo '<a href="'.esc_url($mem_social_url).'"><i class="'.esc_attr($icon).'"></i></a>';
                                    endif;
                                endforeach;
                            ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</section>
<?php if(is_array($mem_facts) && !empty($mem_facts)): ?>
<section class="mem_facts">
    <div class="container">
        <div class="row">
            <?php 
                $m = 1;
                foreach($mem_facts as $mf):
                    $mf_class = ($m != count($mem_facts)) ? 'MEMBR' : '';
                    $mem_fact_title = (isset($mf['mem_fact_title']) && $mf['mem_fact_title'] != '') ? $mf['mem_fact_title'] : '';
                    $mem_fact_num = (isset($mf['mem_fact_num']) && $mf['mem_fact_num'] != '') ? $mf['mem_fact_num'] : '';
                    ?>
                    <div class="col-lg-3 col-sm-6 col-md-3 noPadding <?php echo esc_attr($mf_class); ?>">
                        <div class="mem_fact text-center">
                            <?php if($mem_fact_num > 0): ?>
                                <h1 data-counter="<?php echo esc_attr($mem_fact_num); ?>" class="timer"><?php echo esc_html($mem_fact_num); ?></h1>
                            <?php endif; ?>
                            <?php if($mem_fact_title != ''): ?>
                                <h3><?php echo esc_html($mem_fact_title); ?></h3>
                            <?php endif; ?>
                        </div>
                    </div>
                    <?php
                    $m++;
                endforeach;
            ?>
        </div>
    </div>
</section>
<?php endif; ?>
<?php endwhile; ?>
<?php
    $is_colleague = get_theme_mod('is_colleague', 1);
    $mem_col_subtitle = get_theme_mod('mem_col_subtitle', '');
    $mem_col_title = get_theme_mod('mem_col_title', '');
    $mem_col_num = get_theme_mod('mem_col_num', 5);
    
    if($is_colleague == 1):
?>
    <section class="commonSection sectionColleague">
        <div class="container">
            <?php if($mem_col_subtitle != '' || $mem_col_title != ''): ?>
            <div class="row">
                <div class="col-lg-12 text-center">
                    <?php if($mem_col_subtitle != ''): ?>
                        <h6 class="sub_title"><?php echo esc_html($mem_col_subtitle); ?></h6>
                    <?php endif; ?>
                    <?php if($mem_col_title != ''): ?>
                        <h2 class="sec_title with_bar"><span><?php echo esc_html($mem_col_title); ?></span></h2>
                    <?php endif; ?>
                </div>
            </div>
            <?php endif; ?>
            <div class="row">
                <div class="col-xl-12">
                <?php
                    $tmargs = array(
                        'post_type'             => 'member',
                        'post_status'           => 'publish',
                        'orderby'               => 'date',
                        'order'                 => 'desc',
                        'posts_per_page'        => $mem_col_num,
                        'post__not_in'          => array($postID)
                    );
                    $teamss = new WP_Query($tmargs);
                    if($teamss->have_posts()):
                        echo '<div class="colueage_slider owl-carousel">';
                            while($teamss->have_posts()): 
                                $teamss->the_post();
                                $mem_designation = '';
                                $mem_socials = array();
                                if(defined('FW')){
                                    $mem_designation = fw_get_db_post_option(get_the_ID(), 'mem_designation', '');
                                    $mem_socials = fw_get_db_post_option(get_the_ID(), 'mem_socials', array());
                                }
                                ?>
                                <div class="singleTeam02">
                                    <div class="st2_inner">
                                        <?php if(has_post_thumbnail()): ?>
                                            <?php echo get_the_post_thumbnail(get_the_ID(), 'industing-team-2'); ?>
                                        <?php else: ?>
                                            <img src="http://via.placeholder.com/342x342" alt="<?php the_title_attribute(); ?>">
                                        <?php endif; ?>
                                            <h2><a href="<?php echo get_the_permalink(); ?>"><?php echo get_the_title(); ?></a></h2>
                                        <?php if($mem_designation != ''): ?>
                                            <span><?php echo esc_html($mem_designation); ?></span>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <?php
                            endwhile;
                        echo '</div>';
                    endif;
                    wp_reset_postdata();
                ?>
            </div>            
        </div>
        </div>
    </section>
<?php
    endif;
    $sing_member_bloks = get_theme_mod('sing_member_bloks', '');
    $blocks_id = array();
    if(!empty($sing_member_bloks)){
        foreach($sing_member_bloks as $sb):
            if($sb['block_ids'] != '' && $sb['block_ids'] != 'none'):
                $blocks_id[] = $sb['block_ids'];
            endif;
        endforeach;
        $bloks = array(
            'post_type'     => 'blocks',
            'post_status'   => 'publish',
            'post__in'      => $blocks_id
        );
        $blok = new WP_Query($bloks);
        if($blok->have_posts()):
            while($blok->have_posts()):
            $blok->the_post();
            the_content();
            endwhile;
        endif;
    }
get_footer();