<?php
/**
 * Displays top navigation
 */

$social_links = get_theme_mod('social_links', array());

$is_sticky = get_theme_mod('is_sticky', 2);
$industing_logo = get_theme_mod('industing_logo', '');
$header_infos = get_theme_mod('header_infos', array());
$is_search = get_theme_mod('is_search', 1);
$is_popup = get_theme_mod('is_popup', 2);
$is_cart = get_theme_mod('is_cart', 2);
$is_social_header = get_theme_mod('is_social_header', 2);

$popup_logo = get_theme_mod('popup_logo', '');
$is_social_pop = get_theme_mod('is_social_pop', 2);
$popup_infos = get_theme_mod('popup_infos', array());
?>
<section class="topbar">
    <div class="header-container">
        <div class="row">
            <div class="col-xl-4 col-lg-4 col-md-3 noPadding">
                <div class="logo text-left <?php if ($industing_logo == ''){ echo 'textLogo'; } ?>">
                    <a href="<?php echo esc_url(home_url('/')); ?>">
                        <?php if($industing_logo != ''): ?>
                            <img src="<?php echo esc_url($industing_logo); ?>" alt="<?php echo get_bloginfo('name'); ?>"/>
                        <?php else: ?>
                            <?php echo get_bloginfo('name'); ?>
                        <?php endif; ?>
                    </a>
                </div>
            </div>
            <div class="col-xl-8 col-lg-8 col-md-9">
                <div class="topbar_right text-right">
                    <?php if(!empty($header_infos)): ?>
                        <?php 
                            foreach($header_infos as $hi):
                                $inf_type = (isset($hi['inf_type']) && $hi['inf_type'] != '' ? $hi['inf_type'] : 1);
                                $inf_label = (isset($hi['inf_label']) && $hi['inf_label'] != '' ? $hi['inf_label'] : '');
                                $inf_val = (isset($hi['inf_label']) && $hi['inf_val'] != '' ? $hi['inf_val'] : '');
                                if($inf_type > 0 && $inf_label != '' && $inf_val != ''):
                                    $icon = ($inf_type == 2 ? 'twi-phone' : 'twi-envelope');
                                    ?>
                                    <div class="topbar_element info_element">
                                        <i class="<?php echo esc_attr($icon); ?>"></i>
                                        <h5><?php echo esc_html($inf_label) ?></h5>
                                        <?php if($inf_type == 1): ?>
                                            <p><a href="mailto:<?php echo esc_attr($inf_val); ?>"><?php echo esc_html($inf_val); ?></a></p>
                                        <?php else: ?>
                                            <p><?php echo esc_html($inf_val); ?></p>
                                        <?php endif; ?>
                                    </div>
                                    <?php
                                endif;
                            endforeach;
                        ?>
                    <?php endif; ?>
                    <?php if($is_search == 1): ?>
                        <div class="topbar_element search_element">
                            <form method="get" action="<?php echo esc_url( home_url( '/' ) ); ?>">
                                <i class="twi-search"></i>
                                <input type="search" name="s" placeholder="<?php echo esc_html__('Search keyword...', 'industing') ?>"/>
                            </form>
                        </div>
                    <?php endif; ?>
                    <?php if($is_cart == 1 && class_exists( 'WooCommerce' )): ?>
                        <?php
                            global $woocommerce;
                        ?>
                        <div class="topbar_element settings_cart">
                            <a href="<?php echo wc_get_cart_url(); ?>" class="cartToggler"><i class="twi-shopping-cart2"></i><span><?php echo sprintf(_n('%d', '%d', $woocommerce->cart->cart_contents_count, 'industing'), $woocommerce->cart->cart_contents_count);?></span></a>
                        </div>
                    <?php endif; ?>
                    <?php if($is_popup == 1): ?>
                        <div class="topbar_element settings_bar">
                            <a href="#" class="hamburger" id="open-overlay-nav"><i class="twi-bars2"></i></a>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="nav_bar" <?php if($is_sticky == 1){ ?>id="fix_nav" <?php } ?>>
    <div class="header-container">
        <div class="row">
            <?php if($is_social_header == 1 && !empty($social_links)): ?>
            <div class="col-xl-8 col-lg-9">
            <?php else: ?>
            <div class="col-xs-12">
            <?php endif; ?>
                <div class="mobileMenuBar">
                    <a href="javascript: void(0);"><span><?php echo esc_html__('Menu', 'industing') ?></span><i class="twi-bars"></i></a>
                </div>
                <nav class="mainmenu">
                    <?php
                        if(has_nav_menu('primary-menu'))
                        {
                            wp_nav_menu(array(
                                'theme_location' => 'primary-menu',
                                'container' => FALSE,
                                'menu_class' => '',
                                'menu_id' => '',
                                'echo' => true
                            ));
                        }
                        else
                        {
                            echo '<ul class="dl-menu dl-menuopen">';
                                echo '<li><a href="#">' . esc_html__('No Menu Available', 'industing') . '</a></li>';
                            echo '</ul>';
                        }
                    ?>
                </nav>
            </div>
            <?php if($is_social_header == 1 && !empty($social_links)): ?>
            <div class="col-xl-4 col-lg-3">
                <div class="top_social text-right">
                    <?php
                        foreach($social_links as $sl ):
                            $social_profile = (isset($sl['social_profile']) ? $sl['social_profile'] : '');
                            $social_url = (isset($sl['social_url']) ? $sl['social_url'] : '');
                            if($social_profile != '' && $social_url != ''):
                            ?>
                                <a href="<?php echo esc_url($social_url); ?>"><i class="<?php echo esc_attr($social_profile); ?>"></i></a>
                            <?php
                            endif;
                        endforeach;
                    ?>
                </div>
            </div>
            <?php endif; ?>
        </div>
    </div>
    <?php if($is_social_header == 1 && !empty($social_links)): ?>
    <span class="right_bgs"></span>
    <?php endif; ?>
</section>

<?php if($is_popup == 1): ?>
<!-- Overlay Menu -->
<div class="popup popup__menu">
    <div class="header-container mobileContainer">
        <div class="row">
            <div class="col-lg-8 text-left">
                <div class="popup_logos <?php if($popup_logo == '') { echo 'popTextLogo';} ?>">
                    <a href="<?php echo esc_url(home_url('/')); ?>">
                        <?php if($popup_logo != ''): ?>
                            <img src="<?php echo esc_url($popup_logo); ?>" alt="<?php echo get_bloginfo('name'); ?>">
                        <?php else: ?>
                            <?php echo get_bloginfo('name'); ?>
                        <?php endif; ?>
                    </a>
                </div>
            </div>
            <div class="col-lg-4 text-right">
                <a href="" id="close-popup" class="close-popup"></a>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-12">
                <div class="popup-inner">
                    <div class="dl-menu__wrap dl-menuwrapper">
                        <?php
                            if(has_nav_menu('popup-menu'))
                            {
                                wp_nav_menu(array(
                                    'theme_location' => 'popup-menu',
                                    'container' => FALSE,
                                    'menu_class' => 'dl-menu dl-menuopen',
                                    'menu_id' => '',
                                    'echo' => true,
                                    'walker' => new Industing_Popup_Menu_Walker()
                                ));
                            }
                            else
                            {
                                echo '<ul class="dl-menu dl-menuopen">';
                                    echo '<li><a href="#">' . esc_html__('No Menu Available', 'industing') . '</a></li>';
                                echo '</ul>';
                            }
                        ?>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-6 col-sm-6 col-xs-12 text-left">
                <?php if(!empty($popup_infos)): ?>
                <ul class="footer__contacts">
                    <?php 
                        foreach($popup_infos as $pi):
                            $inf_label = (isset($pi['inf_label']) ? $pi['inf_label'] : '');
                            $inf_val = (isset($pi['inf_val']) ? $pi['inf_val'] : '');
                            if($inf_label != '' && $inf_val != ''):
                            ?>
                            <li><?php echo esc_html($inf_label); ?> <?php echo esc_html($inf_val); ?></li>
                            <?php
                            endif;
                        endforeach;
                    ?>
                </ul>
                <?php endif; ?>
            </div>
            <div class="col-lg-6 col-sm-6 col-xs-12 col-xs-12">
                <?php if($is_social_pop == 1 && !empty($social_links)): ?>
                <div class="foo_social popUp_social text-right">
                    <?php
                        foreach($social_links as $sl ):
                            $social_profile = (isset($sl['social_profile']) ? $sl['social_profile'] : '');
                            $social_url = (isset($sl['social_url']) ? $sl['social_url'] : '');
                            if($social_profile != '' && $social_url != ''):
                            ?>
                            <a href="<?php echo esc_url($social_url); ?>"><i class="<?php echo esc_attr($social_profile); ?>"></i></a>
                            <?php
                            endif;
                        endforeach;
                    ?>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<!-- /Overlay Menu -->
<?php endif; ?>