<?php
/**
 * The Template for displaying product archives, including the main shop page which is a post type archive
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/archive-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.4.0
 */

defined( 'ABSPATH' ) || exit;

get_header( 'shop' );
get_template_part( 'template-parts/header/shop', 'header' );

$shop_view = get_theme_mod('shop_view', 1);
$shop_is_view_switch = get_theme_mod('shop_is_view_switch', 1);
$shop_is_count = get_theme_mod('shop_is_count', 1);
$shop_is_search = get_theme_mod('shop_is_search', 1);
$shop_is_order = get_theme_mod('shop_is_order', 1);
$shop_sidebar = get_theme_mod('shop_sidebar', 1);
$shop_pro_per_page = get_theme_mod('shop_pro_per_page', 8);
$shop_pagi_align = get_theme_mod('shop_pagi_align', 'center');
$class = '';
$pro_col = '';
$list_class = '';
if($shop_sidebar == 1){
    $class = 'col-lg-12';
    $pro_col = 'col-xl-4 col-md-6 col-lg-4';
    $list_class = 'inFullView';
}else{
    $class = 'col-xl-8 col-md-12 col-lg-8';
    $pro_col = 'col-xl-6 col-md-6';
    $list_class = 'inSidebarView';
}
?>
<section class="commonSection shopLoopPage">
    <div class="container">
        <div class="row">
            <div class="col-lg-12 wp_all_notice_area">
                <?php echo woocommerce_output_all_notices(); ?>
            </div>
        </div>
        <div class="row mb50">
            <div class="col-xl-3 col-md-3">
                <?php if($shop_is_view_switch == 1): ?>
                <div class="shopViewBtn">
                    <a href="#" class="toggleProductView <?php if($shop_view == 1 ){ ?>active<?php } ?>" data-proclass="product_grid_items"><i class="twi-th2"></i></a>
                    <a href="#" class="toggleProductView <?php if($shop_view == 2 ){ ?>active<?php } ?>" data-proclass="list_product_items"><i class="twi-bars2"></i></a>
                </div>
                <?php endif; ?>
            </div>
            <div class="col-xl-9 col-md-9">
                <div class="shopAccess text-right">
                    <?php if($shop_is_count == 1 && function_exists('woocommerce_result_count')): ?>
                        <?php echo woocommerce_result_count(); ?>
                    <?php endif; ?>
                    <?php if($shop_is_order == 1 && function_exists('woocommerce_catalog_ordering')): ?>
                        <?php echo woocommerce_catalog_ordering(); ?>
                    <?php endif; ?>
                    <?php if($shop_is_search == 1): ?>
                        <div class="searchForms2">
                            <?php wc_get_template_part( 'search', 'bar' ); ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <div class="row">
            <?php if($shop_sidebar == 2 && is_active_sidebar('sidebar-4')): ?>
                <div class="col-xl-4 col-md-12 col-lg-4">
                    <div class="sidebar_2 inLeft">
                        <?php dynamic_sidebar('sidebar-4'); ?>
                    </div>
                </div>
            <?php endif; ?>
            <div class="<?php echo esc_attr($class); ?>">
                <div class="row">
                    <?php
                        if(woocommerce_product_loop()){
                            if(wc_get_loop_prop('total')){
                                while ( have_posts() ) {
                                    the_post();
                                    echo '<div class="'.$pro_col.' product_grid_items '.($shop_view == 2 ? 'hideNow' : '').'">';
                                        wc_get_template_part( 'content', 'product' );
                                    echo '</div>';
                                    echo '<div class="col-lg-12 list_product_items '.($shop_view == 1 ? 'hideNow' : '').' '.$list_class.'">';
                                        wc_get_template_part( 'content-list', 'product' );
                                    echo '</div>';
                                }
                            }
                            ?>
                            <div class="clearfix"></div>
                            <div class="col-lg-12 col-sm-12 mt3">
                                <div class="ind_pagination ind_shop_pagi text-<?php echo esc_attr($shop_pagi_align); ?>">
                                    <?php echo woocommerce_pagination(); ?>
                                </div>
                            </div>
                            <?php
                        }else{
                            do_action( 'woocommerce_no_products_found' );
                        }
                    ?>
                </div>
            </div>
            <?php if($shop_sidebar == 3 && is_active_sidebar('sidebar-4')): ?>
                <div class="col-xl-4 col-md-12 col-lg-4">
                    <div class="sidebar_2">
                        <?php dynamic_sidebar('sidebar-4'); ?>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>
</section>

<?php
    $shop_bloks = get_theme_mod('shop_bloks', '');
    $blocks_id = array();
    if(!empty($shop_bloks)){
        foreach($shop_bloks as $sb):
            if($sb['block_ids'] != '' && $sb['block_ids'] != 'none'):
                $blocks_id[] = $sb['block_ids'];
            endif;
        endforeach;
        $bloks = array(
            'post_type'     => 'blocks',
            'post_status'   => 'publish',
            'post__in'      => $blocks_id
        );
        $blok = new WP_Query($bloks);
        if($blok->have_posts()):
            while($blok->have_posts()):
            $blok->the_post();
            the_content();
            endwhile;
        endif;
    }
get_footer( 'shop' );
