<?php
/**
 * Single Product tabs
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/tabs/tabs.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.8.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Filter tabs and allow third parties to add their own.
 *
 * Each tab is an array containing title, callback and priority.
 *
 * @see woocommerce_default_product_tabs()
 */
$product_tabs = apply_filters( 'woocommerce_product_tabs', array() );

if ( ! empty( $product_tabs ) ) : ?>
    <div class="col-lg-12">
        <ul class="nav nav-tabs productTabs" id="productTab" role="tablist">
            <?php $i = 1; foreach ( $product_tabs as $key => $product_tab ) : ?>
                <li class="nav-item">
                    <a class="nav-link <?php if($i == 1) { echo 'active'; } ?>" id="<?php echo esc_attr( $key ); ?>-tab" data-toggle="tab" href="#<?php echo esc_attr( $key ); ?>" role="tab" aria-controls="<?php echo esc_attr( $key ); ?>" aria-selected="<?php if($i == 1) { echo 'true'; } else{ echo 'false'; } ?>"><?php echo wp_kses_post( apply_filters( 'woocommerce_product_' . $key . '_tab_title', $product_tab['title'], $key ) ); ?></a>
                </li>
            <?php $i++; endforeach; ?>
        </ul>
    </div>
    <div class="clearfix"></div>
    <div class="col-xl-8 offset-xl-2 col-lg-10 offset-lg-1">
        <div class="tab-content productTabContent" id="productTabContent">
            <?php $i = 1; foreach ( $product_tabs as $key => $product_tab ) : ?>
                <div class="tab-pane fade <?php if($i == 1) { echo 'show active'; } ?>" id="<?php echo esc_attr( $key ); ?>" role="tabpanel" aria-labelledby="<?php echo esc_attr( $key ); ?>-tab">
                    <?php
                        if ( isset( $product_tab['callback'] ) ) {
                            call_user_func( $product_tab['callback'], $key, $product_tab );
                        }
                    ?>
                </div>
            <?php $i++; endforeach; ?>
        </div>
    </div>

<?php endif; ?>
